dump:			ld	a,(int_ticks)		;Signal border
			cp	4
			jr	c,dump			;Await for the 4th interrupt
			halt				;Go to start of frame number 5
			ld	a,(msxHZ)
			cp	5
			jr	nz,jp_dump		;Do 60Hz style dump

							;50Hz style dump
			ld	a,(duration_1st)	;Check if there are characters to dump in the 1st third
			and	a
			jp	z,dump_50		;No? go dump the rest
			ld	b,a
			ld	a,(VDPportWRITE)	;Get VDP write port
			ld	c,a
			push	bc			;Keep port and number of bytes to dump in stack
			ld	a,$40
                	out     (c),a
                	ld	a,$47
                	out     (c),a			;Hard coded VRAM address: 0740h -> character 232
			ld	hl,(carbuffer)		;Origin start address
			dec	c			;Data port instead of control
dump_1stthirdchars:	outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi				;High speed VRAM transfer
			jr	nz,dump_1stthirdchars	;Repeat for all needed characters
			pop	bc			;Restore number of bytes & port
			ld	a,$40
                	out     (c),a
                	ld	a,$67
                	out     (c),a			;Hard coded VRAM address: 2740h -> color 232
			ld	hl,(colorbuffer)	;Origin start address
			dec	c			;Data port instead of control
dump_1stthirdcolors:	outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi				;High speed VRAM transfer
			jr	nz,dump_1stthirdcolors	;Repeat for all needed colors
			jp	dump_50			;Keep with the main dump

							;60Hz style dump
jp_dump:		call	dofirststepsframe	;Do the first steps for the next frame
			ld	bc,(duration_1st)	;Check if there are characters to dump in the 1st third
			ld	a,b
			or	c
			jr	z,dump_60		;


			ld	hl,280
jp_diley_befjump:	dec	hl
			ld	a,h
			or	l
			jr	nz,jp_diley_befjump	;Do a small delay to avoid garbare in the first third
			
			ld	hl,232*8		;VRAM address to write to (character 232)
			ld	de,(carbuffer)		;Origin start address
			push	bc			;Keep number of bytes
			call	ldrvrm			;Do slow VRAM transfer
			pop	bc			;Restore number of bytes
			ld	hl,2000h+232*8		;VRAM address to write to (color 232)
			ld	de,(colorbuffer)	;Origin start address
			call	ldrvrm			;Do slow VRAM transfer
			ld	a,(int_ticks)		;Get number of ticks
			cp	6			;If we're already at 6...
			jr	z,dump_50		;...don't wait for another halt

dump_60:		ei				;Enable interrupts (this shouldn't be needed)
			halt				;Here we're at 6 in 60Hz

dump_50:		ld	hl,screenbuffer		;Dump 1st third of the screen
			ld	a,(VDPportWRITE)	;Get VDP write port
			ld	c,a			;Into C
			xor	a
dump_1stthird:		out	(c),a			;0 low part
			ld	a,88
			out	(c),a			;1800h -> first third of screen
			dec	c			;Data port
			outi				;Transfer 16 bytes at high speed
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi				
			inc	c			;Control port
			ld	a,l
			add	a,16
			ld	l,a			;Jump 16 bytes in screen buffer
			jr	nc,dump_1stthird	;Keep dumping the left half of first third
			inc	h			;Point to second third in screen buffer
			out	(c),a
			ld	a,89
			out	(c),a			;Point to second third in VRAM
			dec	c			;Data port
			outi				;Dump 2nd third of the screen, all 256 bytes at highest speed.
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			ld	b,128			;128 more bytes
dump_3rdthird:		inc	c			;Control port
			ld	a,l
			add	a,16
			ld	l,a			;Jump 16 bytes in screen buffer
			out	(c),a
			ld	a,90
			out	(c),a			;3rd third in VRAM
			dec	c			;Data port
			outi				;Transfer 16 bytes at high speed
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			jr	nz,dump_3rdthird	;Dump 3rd third of the screen, 16 bytes at a time (until counter B reaches 0)
			outi				;Dump sprites, another 128 bytes
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			outi
			ld	bc,(duration_3rd)		;Finally, check if there are characters to dump in 3rd third
			ld	a,b
			or	c
			ret	z				;No: exit
			ld	hl,1000h+224*8			;Fixed VRAM position character 224
			ld	de,(carbuffer3)			;Origin start address
			push	bc
			call	ldrvrm				;Slow speed dump
			pop	bc
			ld	hl,3000h+224*8			;Fixed VRAM position color 224
			ld	de,(colorbuffer3)		;Origin start address
			call	ldrvrm				;Slow speed dump
			ret
